<?php

if (!isset($argv[1]) && !isset($argv[2])) {
    echo 'There is no file';
    exit;
}

$type = $argv[1];

if (!in_array($type, ['image', 'database'])) {
    echo 'You must specify type "image" or "database"';
    exit;
}

$destination_file = $argv[2];
$source_file = __DIR__.'/'.$destination_file;
$ftp_server = 'ftp.cluster010.hosting.ovh.net';
$ftp_user_name = 'materield-backup';
$ftp_password = getenv('APP_SCRIPTS_FTP_PASSWORD');

$conn_id = ftp_connect($ftp_server);
$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_password);

if ((!$conn_id) || (!$login_result)) {
    echo 'Connection failed';
    echo "Trying to connect to $ftp_server with $ftp_user_name";
    exit;
} else {
    echo "Connected to $ftp_server with $ftp_user_name";
}

ftp_pasv($conn_id, true);

$upload = ftp_put($conn_id, $type.'/'.$destination_file, $source_file, FTP_ASCII);

if (!$upload) {
    echo 'Upload failed';
} else {
    echo "Upload succeed : $source_file to $ftp_server with $destination_file";
}

// Rotating files
$files = ftp_nlist($conn_id, $type);
$filesTimed = [];

foreach ($files as $file) {
    if (in_array($file, ['.', '..'])) {
        continue;
    }

    $remoteFile = $type.'/'.$file;
    $filesTimed[ftp_mdtm($conn_id, $remoteFile)] = $remoteFile;
}

krsort($filesTimed);
$filesToRemove = array_slice($filesTimed, 'image' === $type ? 2 : 30);

foreach ($filesToRemove as $file) {
    ftp_delete($conn_id, $file);
}

ftp_close($conn_id);
