<?php

declare(strict_types=1);

namespace App\Controller;

use App\Service\SettingService;
use Sylius\Component\Core\Model\OrderInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;

class SettingController extends AbstractController
{
    /** @var SettingService */
    protected $settingService;

    /**
     * ConfigurationController constructor.
     *
     * @param SettingService $settingService
     */
    public function __construct(SettingService $settingService)
    {
        $this->settingService = $settingService;
    }

    /**
     * @param OrderInterface $order
     *
     * @return Response
     */
    public function managementFees(OrderInterface $order): Response
    {
        $minimumFees = $this->settingService->getMinimumManagementFees();

        return $this->render('shop/setting/managementFees.html.twig', [
            'order' => $order,
            'minimumFees' => (int) $minimumFees->getContent(),
        ]);
    }

    /**
     * @return Response
     */
    public function shippingFees(): Response
    {
        return $this->render('shop/setting/shippingFees.html.twig', [
            'fees' => $this->settingService->getShippingFees(),
        ]);
    }
}
