<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Address as BaseAddress;

/**
 * @ORM\Table(name="sylius_address")
 * @ORM\Entity
 * @ORM\AttributeOverrides({
 *      @ORM\AttributeOverride(name="firstName",
 *          column=@ORM\Column(
 *              name     = "first_name",
 *              type     = "string",
 *              length   = 255,
 *              nullable = true
 *          )
 *      ),
 *      @ORM\AttributeOverride(name="lastName",
 *          column=@ORM\Column(
 *              name     = "last_name",
 *              type     = "string",
 *              length   = 255,
 *              nullable = true
 *          )
 *      )
 * })
 */
class Address extends BaseAddress
{
    const CIVILITY_MR = 'Mr';
    const CIVILITY_MME = 'Mme';
    const CIVILITY_SOCIETE = 'Société';
    const CIVILITY_EARL = 'EARL';
    const CIVILITY_EURL = 'EURL';
    const CIVILITY_GAEC = 'GAEC';
    const CIVILITY_SARL = 'SARL';
    const CIVILITY_SA = 'SA';
    const CIVILITY_SAS = 'SAS';
    const CIVILITY_SC = 'SC';
    const CIVILITY_SCA = 'SCA';
    const CIVILITY_SCI = 'SCI';
    const CIVILITY_SCOP = 'SCOP';
    const CIVILITY_SCP = 'SCP';
    const CIVILITY_SICA = 'SICA';
    const CIVILITY_SNC = 'SNC';

    const TYPE_PARTICULIER = 'Particulier';
    const TYPE_SOCIETE = 'Société';
    const TYPE_ADMINISTRATION = 'Administration';

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $type;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $civility;

    /**
     * @ORM\Column(name="fax_number", type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $faxNumber;

    /**
     * @ORM\Column(name="mobile_phone_number", type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $mobilePhoneNumber;

    public function __construct()
    {
        parent::__construct();

        $this->type = self::TYPE_PARTICULIER;
    }

    public function __clone()
    {
        $this->id = null;
        $this->createdAt = null;
        $this->updatedAt = null;
    }

    public function getCivility(): ?string
    {
        return $this->civility;
    }

    /**
     * @return Address
     */
    public function setCivility(string $civility): self
    {
        $this->civility = $civility;

        return $this;
    }

    public function getFaxNumber(): ?string
    {
        return $this->faxNumber;
    }

    /**
     * @return Address
     */
    public function setFaxNumber(string $faxNumber): self
    {
        $this->faxNumber = $faxNumber;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return Address
     */
    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getMobilePhoneNumber(): ?string
    {
        return $this->mobilePhoneNumber;
    }

    /**
     * @return Address
     */
    public function setMobilePhoneNumber(?string $mobilePhoneNumber): self
    {
        $this->mobilePhoneNumber = $mobilePhoneNumber;

        return $this;
    }

    public function replaceUnknown(): void
    {
        $this->lastName = 'unknown' === $this->lastName ? null : $this->lastName;
        $this->firstName = 'unknown' === $this->firstName ? null : $this->firstName;
        $this->company = 'unknown' === $this->company ? null : $this->company;
        $this->street = 'unknown' === $this->street ? null : $this->street;
        $this->city = 'unknown' === $this->city ? null : $this->city;
        $this->postcode = 'unknown' === $this->postcode ? null : $this->postcode;
        $this->phoneNumber = 'unknown' === $this->phoneNumber ? null : $this->phoneNumber;
    }
}
