<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use EWZ\Bundle\RecaptchaBundle\Validator\Constraints as Recaptcha;
use Sylius\Component\Core\Model\Customer as BaseCustomer;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="sylius_customer")
 * @ORM\Entity
 * @UniqueEntity("identifier")
 */
class Customer extends BaseCustomer
{
    const CIVILITY_MR = 'Mr';
    const CIVILITY_MME = 'Mme';
    const CIVILITY_SOCIETE = 'Société';
    const CIVILITY_EARL = 'EARL';
    const CIVILITY_EURL = 'EURL';
    const CIVILITY_GAEC = 'GAEC';
    const CIVILITY_SARL = 'SARL';
    const CIVILITY_SA = 'SA';
    const CIVILITY_SAS = 'SAS';
    const CIVILITY_SC = 'SC';
    const CIVILITY_SCA = 'SCA';
    const CIVILITY_SCI = 'SCI';
    const CIVILITY_SCOP = 'SCOP';
    const CIVILITY_SCP = 'SCP';
    const CIVILITY_SICA = 'SICA';
    const CIVILITY_SNC = 'SNC';

    const TYPE_PARTICULIER = 'Particulier';
    const TYPE_SOCIETE = 'Société';
    const TYPE_ADMINISTRATION = 'Administration';

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $type;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $civility;

    /**
     * @ORM\Column(name="company_name", type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $companyName;

    /**
     * @ORM\Column(name="fax_number", type="string", length=255, nullable=true)
     *
     * @var string
     */
    protected $faxNumber;

    /**
     * @ORM\Column(name="export_sage", type="boolean")
     *
     * @var bool
     */
    protected $exportSage = false;

    /**
     * @ORM\Column(name="old_customer_id", type="integer", nullable=true)
     *
     * @var int
     */
    protected $oldCustomerId;

    /**
     * @ORM\Column(name="identifier", type="string", length=255, nullable=true, unique=true)
     *
     * @var string|null
     */
    protected $identifier;

    /**
     * @var string|null
     * @Assert\NotBlank(groups={"app_b2c", "app_b2b", "app_b2g"}, message="Les deux champs 'Mot de passe' doivent être rempli et être identiques.")
     * @Assert\Length(min="4", groups={"sylius", "app_b2c", "app_b2b", "app_b2g"})
     */
    protected $password;

    /**
     * @Recaptcha\IsTrue(groups={"sylius"})
     */
    protected $recaptcha;

    public function getPassword(): ?string
    {
        return $this->password;
    }

    /**
     * @return Customer
     */
    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    public function getCivility(): ?string
    {
        return $this->civility;
    }

    /**
     * @return Customer
     */
    public function setCivility(string $civility): self
    {
        $this->civility = $civility;

        return $this;
    }

    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    /**
     * @return Customer
     */
    public function setCompanyName(?string $companyName): self
    {
        $this->companyName = $companyName;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @return Customer
     */
    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getFaxNumber(): ?string
    {
        return $this->faxNumber;
    }

    /**
     * @return Customer
     */
    public function setFaxNumber(string $faxNumber): self
    {
        $this->faxNumber = $faxNumber;

        return $this;
    }

    public function isExportSage(): bool
    {
        return $this->exportSage;
    }

    /**
     * @return Customer
     */
    public function setExportSage(bool $exportSage): self
    {
        $this->exportSage = $exportSage;

        return $this;
    }

    public function getOldCustomerId(): ?int
    {
        return $this->oldCustomerId;
    }

    /**
     * @return Customer
     */
    public function setOldCustomerId(int $oldCustomerId): self
    {
        $this->oldCustomerId = $oldCustomerId;

        return $this;
    }

    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    /**
     * @return Customer
     */
    public function setIdentifier(?string $identifier): self
    {
        $this->identifier = $identifier;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getRecaptcha()
    {
        return $this->recaptcha;
    }

    /**
     * @param mixed $recaptcha
     */
    public function setRecaptcha($recaptcha): void
    {
        $this->recaptcha = $recaptcha;
    }
}
