<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Image;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="app_product_commercial_documentation")
 * @ORM\Entity
 */
class ProductCommercialDocumentation extends Image
{
    /**
     * @ORM\ManyToOne(targetEntity="Product", inversedBy="commercialDocumentations")
     * @ORM\JoinColumn(name="owner_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
     *
     * @Assert\File(
     *     maxSize = "10240k",
     *     mimeTypes = {"application/pdf", "application/x-pdf"},
     *     mimeTypesMessage = "Please upload a valid PDF"
     * )
     *
     * @var Product
     */
    protected $owner;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var bool
     */
    protected $active;

    /**
     * @ORM\Column(name="professional_place", type="boolean")
     *
     * @var bool
     */
    protected $professionalPlace;

    public function __construct()
    {
        $this->active = false;
        $this->professionalPlace = false;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @param bool $active
     *
     * @return ProductCommercialDocumentation
     */
    public function setActive(bool $active): self
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return bool
     */
    public function isProfessionalPlace(): bool
    {
        return $this->professionalPlace;
    }

    /**
     * @param bool $professionalPlace
     *
     * @return ProductCommercialDocumentation
     */
    public function setProfessionalPlace(bool $professionalPlace): self
    {
        $this->professionalPlace = $professionalPlace;

        return $this;
    }
}
