<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\ProductTranslation as BaseProductTranslation;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="sylius_product_translation")
 * @ORM\Entity
 */
class ProductTranslation extends BaseProductTranslation
{
    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @Assert\NotBlank
     */
    protected $title;

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): self
    {
        $this->title = $title;

        return $this;
    }
}
