<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\ResourceInterface;

/**
 * @ORM\Table(name="app_sending_criterion")
 * @ORM\Entity(repositoryClass="App\Repository\SendingCriterionRepository")
 */
class SendingCriterion implements ResourceInterface
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    private $type;

    /**
     * @ORM\Column(name="order_number", type="integer")
     */
    private $orderNumber;

    /**
     * @ORM\Column(name="order_number_sign", type="string", length=255)
     */
    private $orderNumberSign;

    /**
     * @ORM\Column(name="number_of_product", type="integer")
     */
    private $numberOfProduct;

    /**
     * @ORM\Column(name="number_of_product_sign", type="string", length=255)
     */
    private $numberOfProductSign;

    /**
     * @ORM\Column(name="order_total", type="integer")
     */
    private $orderTotal;

    /**
     * @ORM\Column(name="order_total_sign", type="string", length=255)
     */
    private $orderTotalSign;

    /**
     * @ORM\Column(name="product_code", type="string", length=255)
     */
    private $productCode;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getOrderNumber(): ?int
    {
        return $this->orderNumber;
    }

    public function setOrderNumber(int $orderNumber): self
    {
        $this->orderNumber = $orderNumber;

        return $this;
    }

    public function getOrderNumberSign(): ?string
    {
        return $this->orderNumberSign;
    }

    public function setOrderNumberSign(string $orderNumberSign): self
    {
        $this->orderNumberSign = $orderNumberSign;

        return $this;
    }

    public function getNumberOfProduct(): ?int
    {
        return $this->numberOfProduct;
    }

    public function setNumberOfProduct(int $numberOfProduct): self
    {
        $this->numberOfProduct = $numberOfProduct;

        return $this;
    }

    public function getNumberOfProductSign(): ?string
    {
        return $this->numberOfProductSign;
    }

    public function setNumberOfProductSign(string $numberOfProductSign): self
    {
        $this->numberOfProductSign = $numberOfProductSign;

        return $this;
    }

    public function getOrderTotal(): ?int
    {
        return $this->orderTotal;
    }

    public function setOrderTotal(int $orderTotal): self
    {
        $this->orderTotal = $orderTotal;

        return $this;
    }

    public function getOrderTotalSign(): ?string
    {
        return $this->orderTotalSign;
    }

    public function setOrderTotalSign(string $orderTotalSign): self
    {
        $this->orderTotalSign = $orderTotalSign;

        return $this;
    }

    public function getProductCode(): ?string
    {
        return $this->productCode;
    }

    public function setProductCode(string $productCode): self
    {
        $this->productCode = $productCode;

        return $this;
    }
}
