<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\ResourceInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="app_supplier_coefficient")
 * @ORM\Entity(repositoryClass="App\Repository\SupplierCoefficientRepository")
 */
class SupplierCoefficient implements ResourceInterface
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     *
     * @var int
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=6, scale=2)
     * @Assert\Type("double")
     *
     * @var float
     */
    private $coefficient;

    /**
     * @ORM\Column(name="minimum_price", type="decimal", precision=6, scale=2)
     * @Assert\Type("double")
     *
     * @var float
     */
    private $minimumPrice;

    /**
     * @ORM\Column(name="maximum_price", type="decimal", precision=6, scale=2)
     * @Assert\Type("double")
     *
     * @var float
     */
    private $maximumPrice;

    /**
     * @ORM\ManyToOne(targetEntity="Supplier", inversedBy="supplierCoefficients")
     * @ORM\JoinColumn(name="supplier_id", referencedColumnName="id")
     *
     * @var Supplier
     */
    private $supplier;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return float|null
     */
    public function getCoefficient(): ?float
    {
        return (float) $this->coefficient;
    }

    /**
     * @param float $coefficient
     *
     * @return SupplierCoefficient
     */
    public function setCoefficient(float $coefficient): self
    {
        $this->coefficient = $coefficient;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getMinimumPrice(): ?float
    {
        return (float) $this->minimumPrice;
    }

    /**
     * @param float $minimumPrice
     *
     * @return SupplierCoefficient
     */
    public function setMinimumPrice(float $minimumPrice): self
    {
        $this->minimumPrice = $minimumPrice;

        return $this;
    }

    /**
     * @return float|null
     */
    public function getMaximumPrice(): ?float
    {
        return (float) $this->maximumPrice;
    }

    /**
     * @param float $maximumPrice
     *
     * @return SupplierCoefficient
     */
    public function setMaximumPrice(float $maximumPrice): self
    {
        $this->maximumPrice = $maximumPrice;

        return $this;
    }

    /**
     * @return Supplier|null
     */
    public function getSupplier(): ?Supplier
    {
        return $this->supplier;
    }

    /**
     * @param Supplier|null $supplier
     *
     * @return SupplierCoefficient
     */
    public function setSupplier(?Supplier $supplier): self
    {
        $this->supplier = $supplier;

        return $this;
    }
}
