<?php

declare(strict_types=1);

namespace App\Entity;

use BitBag\SyliusCmsPlugin\Entity\Page;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Taxon as BaseTaxon;

/**
 * @ORM\Table(name="sylius_taxon")
 * @ORM\Entity
 */
class Taxon extends BaseTaxon
{
    /**
     * @ORM\Column(type="boolean", nullable=false, options={"default" : false})
     *
     * @var bool
     */
    private $menu = false;

    /**
     * @ORM\ManyToOne(targetEntity="BitBag\SyliusCmsPlugin\Entity\Page")
     * @ORM\JoinColumn(name="page_id", referencedColumnName="id")
     *
     * @var Page|null
     */
    private $page;

    /**
     * @ORM\OneToOne(targetEntity="Taxon")
     * @ORM\JoinColumn(name="redirection_taxon_id", referencedColumnName="id", nullable=true)
     */
    private $redirectionTaxon;

    /**
     * @ORM\Column(name="display_search", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $displaySearch;

    /**
     * @ORM\Column(name="display_search_form", type="boolean", nullable=false)
     *
     * @var bool
     */
    private $displaySearchForm;

    public function __construct()
    {
        parent::__construct();

        $this->displaySearch = false;
        $this->displaySearchForm = false;
    }

    public function isMenu(): bool
    {
        return $this->menu;
    }

    /**
     * @return Taxon
     */
    public function setMenu(bool $menu): self
    {
        $this->menu = $menu;

        return $this;
    }

    public function getPage(): ?Page
    {
        return $this->page;
    }

    /**
     * @return Taxon
     */
    public function setPage(Page $page): self
    {
        $this->page = $page;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->getTranslation()->getTitle();
    }

    public function setTitle(?string $title): void
    {
        $this->getTranslation()->setTitle($title);
    }

    public function getRedirectionTaxon(): ?Taxon
    {
        return $this->redirectionTaxon;
    }

    public function setRedirectionTaxon(?Taxon $taxon): self
    {
        $this->redirectionTaxon = $taxon;

        return $this;
    }

    public function getTaxonDisplay(): string
    {
        if ($this->getParent()) {
            return $this->getParent()->getName().' > '.$this->getName();
        }

        return $this->getName();
    }

    public function isDisplaySearch(): bool
    {
        return $this->displaySearch;
    }

    public function setDisplaySearch(bool $displaySearch): Taxon
    {
        $this->displaySearch = $displaySearch;

        return $this;
    }

    public function isDisplaySearchForm(): bool
    {
        return $this->displaySearchForm;
    }

    public function setDisplaySearchForm(bool $displaySearchForm): Taxon
    {
        $this->displaySearchForm = $displaySearchForm;

        return $this;
    }
}
