<?php

declare(strict_types=1);

namespace App\EventListener;

use App\Entity\Product;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Uploader\ImageUploaderInterface;
use Symfony\Component\EventDispatcher\GenericEvent;
use Webmozart\Assert\Assert;

class ProductPdfUploadListener
{
    /** @var ImageUploaderInterface */
    private $uploader;

    /**
     * ProductPdfUploadListener constructor.
     *
     * @param ImageUploaderInterface $uploader
     */
    public function __construct(ImageUploaderInterface $uploader)
    {
        $this->uploader = $uploader;
    }

    /**
     * @param GenericEvent $event
     */
    public function uploadPdf(GenericEvent $event): void
    {
        $subject = $event->getSubject();
        Assert::isInstanceOf($subject, Product::class);

        $this->uploadSubjectPdf($subject);
    }

    /**
     * @param Product $subject
     */
    private function uploadSubjectPdf(Product $subject): void
    {
        $this->uploadCollection($subject->getCommercialDocumentations());
        $this->uploadCollection($subject->getTechnicalDocumentations());
        $this->uploadCollection($subject->getTechnicalBursts());
    }

    /**
     * @param Collection $pdfs
     */
    private function uploadCollection(Collection $pdfs): void
    {
        foreach ($pdfs as $pdf) {
            if ($pdf->hasFile()) {
                $this->uploader->upload($pdf);
            }

            // Upload failed? Let's remove that image.
            if (null === $pdf->getPath()) {
                $pdfs->removeElement($pdf);
            }
        }
    }
}
