<?php

declare(strict_types=1);

namespace App\Form\Extension;

use Sylius\AdminOrderCreationPlugin\Form\Type\NewOrderType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class NewOrderTypeExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->remove('promotionCoupon')
            ->remove('shippingAddress')
            ->remove('billingAddress')
            ->remove('payments')
            ->remove('shipments')
            ->remove('adjustments')
            ->remove('localeCode')
        ;

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event): void {
            $event->getForm()->remove('localeCode')
            ->remove('currencyCode')
            ->remove('adjustments');
        }, -1);
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'validation_groups' => ['app_cart'],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public static function getExtendedTypes(): iterable
    {
        return [NewOrderType::class];
    }
}
