<?php

declare(strict_types=1);

namespace App\Form\Extension;

use App\Entity\Taxon;
use BitBag\SyliusCmsPlugin\Entity\Page;
use Sylius\Bundle\TaxonomyBundle\Form\Type\TaxonType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;

final class TaxonTypeExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('menu', CheckboxType::class, [
                'label' => 'app.ui.form.menu',
                'required' => false,
            ])
            ->add('displaySearch', CheckboxType::class, [
                'label' => 'app.ui.form.display_taxon_search',
                'required' => false,
            ])
            ->add('displaySearchForm', CheckboxType::class, [
                'label' => 'app.ui.form.display_taxon_search_form',
                'required' => false,
            ])
            ->add('page', EntityType::class, [
                'class' => Page::class,
                'choice_label' => 'getName',
                'required' => false,
            ])
            ->add('redirectionTaxon', EntityType::class, [
                'class' => Taxon::class,
                'choice_label' => 'getTaxonDisplay',
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public static function getExtendedTypes(): iterable
    {
        return [TaxonType::class];
    }
}
