<?php

declare(strict_types=1);

namespace App\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class AdminOrderTicketType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('company_name', TextType::class, [
                'required' => false,
                'label' => 'app.ui.form.company',
            ])
            ->add('last_name', TextType::class, [
                'required' => false,
                'label' => 'app.ui.form.last_name',
            ])
            ->add('first_name', TextType::class, [
                'required' => false,
                'label' => 'app.ui.form.first_name',
            ])
            ->add('phone', TextType::class, [
                'required' => true,
                'label' => 'app.ui.form.phone',
            ])
            ->add('email', EmailType::class, [
                'required' => true,
                'label' => 'app.ui.form.email',
            ])
            ->add('total', TextType::class, [
                'required' => true,
                'label' => 'app.ui.form.total_vat_included',
            ])
        ;
    }
}
