<?php

declare(strict_types=1);

namespace App\Form\Type;

use App\Entity\Taxon;
use App\Repository\TaxonRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;

class AdminProductFinalizeImportType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxon', EntityType::class, [
                'class' => Taxon::class,
                'required' => true,
                'query_builder' => function (TaxonRepository $repository) {
                    return $repository->createQueryBuilder('t')
                        ->innerJoin('t.translations', 'ts')
                        ->andWhere('t.page IS NULL')
                        ->andWhere('t.parent IS NOT NULL')
                        ->addOrderBy('ts.name');
                },
            ])
        ;
    }
}
