<?php

declare(strict_types=1);

namespace App\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class AdminSendingCriterionType extends AbstractResourceType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $sign = [
            '==' => '==',
            '>' => '>',
            '<' => '<',
            '<>' => '<>',
            '>=' => '>=',
            '<=' => '<=',
        ];
        $builder->add('type', ChoiceType::class, [
            'choices' => [
                '' => '',
                'Société' => 'Société',
                'Particulier' => 'Particulier',
                'Administration' => 'Administration',
            ],
        ])
            ->add('orderNumber', TextType::class)
            ->add('orderNumberSign', ChoiceType::class, [
                'choices' => $sign,
            ])
            ->add('numberOfProduct', IntegerType::class)
            ->add('numberOfProductSign', ChoiceType::class, [
                'choices' => $sign,
            ])
            ->add('orderTotal', IntegerType::class)
            ->add('orderTotalSign', ChoiceType::class, [
                'choices' => $sign,
            ])
            ->add('productCode', TextType::class)
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'app_sending_criterion';
    }
}
