<?php

declare(strict_types=1);

namespace App\Menu;

use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AdminMenuListener
{
    /**
     * @param MenuBuilderEvent $event
     */
    public function addAdminMenuItems(MenuBuilderEvent $event): void
    {
        $menu = $event->getMenu()->getChild('catalog');

        if ($menu) {
            $menu->addChild('suppliers', ['route' => 'app_admin_supplier_index'])
                ->setLabel('app.ui.suppliers');
            $menu->addChild('sendingCriterion', ['route' => 'app_admin_sending_criterion_index'])
                ->setLabel('app.ui.sending_criterion');
            $menu->addChild('setting', ['route' => 'app_admin_setting_index'])
                ->setLabel('app.ui.setting');
        }
    }
}
