<?php

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Customer;
use Doctrine\ORM\NonUniqueResultException;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\CustomerRepository as BaseCustomerRepository;

class CustomerRepository extends BaseCustomerRepository
{
    /**
     * @param int $id
     *
     * @return Customer|null
     *
     * @throws NonUniqueResultException
     */
    public function findWithJoin(int $id): ?Customer
    {
        return $this->createQueryBuilder('c')
            ->select('a', 'c')
            ->innerJoin('c.addresses', 'a')
            ->andWhere('c.id = :id')
            ->setParameter('id', $id)
            ->getQuery()
            ->getOneOrNullResult();
    }

    /**
     * @param string $email
     *
     * @return array
     */
    public function findByEmailPart(string $email): array
    {
        return $this->createQueryBuilder('c')
            ->andWhere('c.email LIKE :email')
            ->addOrderBy('c.email')
            ->setParameter('email', $email.'%')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult();
    }
}
