<?php

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Supplier;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class SupplierCoefficientRepository extends EntityRepository
{
    /**
     * @param Supplier $supplier
     * @param float    $price
     *
     * @return array
     */
    public function findBySupplierAndPrice(Supplier $supplier, float $price): array
    {
        return $this->createQueryBuilder('sc')
            ->innerJoin('sc.supplier', 's')
            ->andWhere('s = :supplier')
            ->andWhere(':price BETWEEN sc.minimumPrice AND sc.maximumPrice')
            ->setParameters([
                'supplier' => $supplier,
                'price' => $price,
            ])
            ->getQuery()
            ->getResult();
    }
}
