<?php

declare(strict_types=1);

namespace App\Service;

use Sylius\Component\Core\Model\Channel;
use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Taxation\Calculator\CalculatorInterface;
use Sylius\Component\Taxation\Resolver\TaxRateResolverInterface;

class ProductVariantPriceCalculator
{
    /**
     * @var TaxRateResolverInterface
     */
    private $taxRateResolver;

    /**
     * @var CalculatorInterface
     */
    private $calculator;

    /**
     * @param TaxRateResolverInterface $taxRateResolver
     * @param CalculatorInterface      $calculator
     */
    public function __construct(TaxRateResolverInterface $taxRateResolver, CalculatorInterface $calculator)
    {
        $this->taxRateResolver = $taxRateResolver;
        $this->calculator = $calculator;
    }

    /**
     * @param ProductVariantInterface $variant
     *
     * @return array
     */
    public function getPriceWithTax(ProductVariantInterface $variant): float
    {
        $taxRate = $this->taxRateResolver->resolve($variant);
        $channel = new Channel();
        $channel->setCode('ECOMMERCE');
        $price = $variant->getChannelPricingForChannel($channel)->getPrice();
        $totalTaxAmount = $this->calculator->calculate($price, $taxRate);

        return $taxRate->isIncludedInPrice() ? $price : $price + $totalTaxAmount;
    }
}
