<?php

declare(strict_types=1);

namespace App\Twig;

use App\Service\ProductVariantPriceCalculator;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

final class PriceExtension extends AbstractExtension
{
    /** @var ProductVariantPriceCalculator */
    private $productVariantPriceCalculator;

    /**
     * PriceExtension constructor.
     *
     * @param ProductVariantPriceCalculator $productVariantPriceCalculator
     */
    public function __construct(ProductVariantPriceCalculator $productVariantPriceCalculator)
    {
        $this->productVariantPriceCalculator = $productVariantPriceCalculator;
    }

    /**
     * {@inheritdoc}
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter('price_with_tax', [$this->productVariantPriceCalculator, 'getPriceWithTax']),
        ];
    }
}
