<?php

declare(strict_types=1);

namespace App\Twig;

use App\Helper\SettingHelper;
use App\Service\SettingService;
use Sylius\Component\Order\Context\CartContextInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class SettingExtension extends AbstractExtension
{
    /** @var SettingService */
    private $settingService;

    /** @var SettingHelper */
    private $settingHelper;

    /** @var CartContextInterface */
    private $cartContext;

    /**
     * SettingExtension constructor.
     *
     * @param SettingService       $settingService
     * @param SettingHelper        $settingHelper
     * @param CartContextInterface $cartContext
     */
    public function __construct(SettingService $settingService, SettingHelper $settingHelper, CartContextInterface $cartContext)
    {
        $this->settingService = $settingService;
        $this->settingHelper = $settingHelper;
        $this->cartContext = $cartContext;
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions(): array
    {
        return [
            new TwigFunction('holidayMessage', [$this->settingService, 'getHolidayMessage']),
            new TwigFunction('canUseNPayments', [$this, 'canUserNPayments']),
        ];
    }

    /**
     * @return bool
     */
    public function canUserNPayments(): bool
    {
        return $this->settingHelper->canUseNPayments($this->cartContext->getCart());
    }
}
