<?php

declare(strict_types=1);

namespace App\Tests\Service;

use App\Entity\Customer;
use App\Service\IdentifierService;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\Persistence\ObjectRepository;
use PHPUnit\Framework\TestCase;

class IdentifierServiceTest extends TestCase
{
    /**
     * @dataProvider createIdentifierDataProvider
     */
    public function testCreateIdentifier(Customer $customer, int $count, array $findOneBy, ?string $result): void
    {
        $objectRepository = $this->createMock(ObjectRepository::class);
        $objectRepository->expects($this->exactly($count))
            ->method('findOneBy')
            ->willReturnOnConsecutiveCalls(...$findOneBy);
        $entityManager = $this->createMock(EntityManagerInterface::class);
        $entityManager->expects($this->exactly($count))
            ->method('getRepository')
            ->willReturn($objectRepository);
        $identifierService = new IdentifierService($entityManager);
        $this->assertEquals($result, $identifierService->createIdentifier($customer));
    }

    public function createIdentifierDataProvider(): array
    {
        $customer1 = new Customer();
        $customer1->setType(Customer::TYPE_PARTICULIER);
        $customer1->setCompanyName('Company');
        $customer1->setLastName('Last name');
        $customer1->setFirstName('First name');

        $customer2 = new Customer();
        $customer2->setType(Customer::TYPE_SOCIETE);
        $customer2->setCompanyName('Company');
        $customer2->setLastName('Last name');
        $customer2->setFirstName('First name');

        $customer3 = new Customer();
        $customer3->setType(Customer::TYPE_SOCIETE);
        $customer3->setCompanyName('A');
        $customer3->setLastName('B');
        $customer3->setFirstName('C');

        return [
            [(new Customer()), 0, [], null],
            [$customer1, 1, [null], 'LASTNAMEFIRSTNAME'],
            [$customer3, 2, [true, null], 'A0'],
            [$customer2, 2, [true, null], 'COMPANY0'],
            [$customer2, 12, [true, true, true, true, true, true, true, true, true, true, true, null], 'COMPANY0123456710'],
        ];
    }
}
