<?php

declare(strict_types=1);

namespace Sylius\AdminOrderCreationPlugin\Form\Type;

use Sylius\Bundle\CurrencyBundle\Form\Type\CurrencyChoiceType;
use Sylius\Bundle\ResourceBundle\Form\DataTransformer\ResourceToIdentifierTransformer;
use Sylius\Component\Resource\Repository\RepositoryInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\ReversedTransformer;

final class CurrencyCodeChoiceType extends AbstractType
{
    /** @var RepositoryInterface */
    private $currencyRepository;

    public function __construct(RepositoryInterface $currencyRepository)
    {
        $this->currencyRepository = $currencyRepository;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addModelTransformer(
            new ReversedTransformer(new ResourceToIdentifierTransformer($this->currencyRepository, 'code'))
        );
    }

    public function getParent(): string
    {
        return CurrencyChoiceType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_currency_code_choice';
    }
}
