const Encore = require('@symfony/webpack-encore');
const CopyWebpackPlugin = require('copy-webpack-plugin');
const webpack = require('webpack');
const Terser = require('terser-webpack-plugin');
const ImageminPlugin = require('imagemin-webpack-plugin').default;

Encore.setOutputPath('public/build/');
Encore.setPublicPath('/build');
Encore.enableSingleRuntimeChunk();
Encore.addEntry('app', './assets/js/app.js');
Encore.addEntry('sylius_shop_homepage', './assets/js/sylius_shop_homepage.js');
Encore.addEntry('sylius_shop_contact', './assets/js/sylius_shop_contact.js');
Encore.addEntry('sylius_shop_product_show', './assets/js/sylius_shop_product_show.js');
Encore.addEntry('sylius_shop_checkout_payment', './assets/js/sylius_shop_checkout_payment.js');
Encore.cleanupOutputBeforeBuild();
Encore.enableBuildNotifications();
Encore.enableSourceMaps(!Encore.isProduction());
Encore.enableVersioning(Encore.isProduction());
Encore.enableSassLoader();
Encore.autoProvidejQuery({
    'window.jQuery': 'jquery'
});

const webpackConfig = Encore.getWebpackConfig();
webpackConfig.plugins.push(new CopyWebpackPlugin([
    {
        from: './assets/imgs',
        to: 'imgs',
    },
]));

const MinifyPlugin = require("babel-minify-webpack-plugin");
webpackConfig.plugins.push(new Terser({}, { comments: false }));

const ImageminMozjpeg = require('imagemin-mozjpeg');
const ImageminOptiPng = require('imagemin-optipng');
webpackConfig.plugins.push(new ImageminPlugin({
    disable: false,
    test: /\.(jpeg|jpg|png|gif|svg)$/i,
    optimizationLevel: 3,
    type: Infinity,
    optipng: {
        colorTypeReduction: true,
        paletteReduction: true,
        bitDepthReduction: true,
        optimizationLevel: 7,
    },
    mozJpeg: {
        quality: 0,
        progressive: true,
        targa: true,
        fastCrush: false,
        dcScanOpt: 1,
        trellis: true,
        trellisDC: true,
        quantBaseline: true,
        quantTable: 0,
    }
}));

module.exports = webpackConfig;
