<?php

declare(strict_types=1);

namespace App\Access\Checker;

use Sylius\RbacPlugin\Access\Checker\RouteNameCheckerInterface;

final class HardcodedRouteNameChecker implements RouteNameCheckerInterface
{
    /**
     * @param string $routeName
     *
     * @return bool
     */
    public function isAdminRoute(string $routeName): bool
    {
        return
            false !== strpos($routeName, 'app_admin') ||
            false !== strpos($routeName, 'sylius_admin') ||
            false !== strpos($routeName, 'sylius_rbac_admin')
            ;
    }
}
