<?php

declare(strict_types=1);

namespace App\Controller;

use App\Entity\Product;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class AdminProductAjaxController extends AbstractController
{
    public function index(Request $request, EntityManagerInterface $entityManager)
    {
        $criteria = $request->query->get('criteria');

        return new JsonResponse([
            '_embedded' => [
                'items' => $entityManager->getRepository(Product::class)->findBySearch($criteria['search']['value']),
            ],
        ]);
    }
}
