<?php

declare(strict_types=1);

namespace App\Controller;

use App\Entity\Taxon;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;

class MenuController extends AbstractController
{
    /**
     * @param EntityManagerInterface $entityManager
     *
     * @return Response
     */
    public function index(EntityManagerInterface $entityManager): Response
    {
        return $this->render('@SyliusShop/Menu/index.html.twig', [
            'rootNodes' => $entityManager->getRepository(Taxon::class)->findRootNodesMenu(),
        ]);
    }
}
