<?php

declare(strict_types=1);

namespace App\Controller;

use Sylius\Bundle\UiBundle\Form\Type\SecurityLoginType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\HttpFoundation\Response;

class UserController extends AbstractController
{
    /** @var FormFactoryInterface */
    private $formFactory;

    public function __construct(FormFactoryInterface $formFactory)
    {
        $this->formFactory = $formFactory;
    }

    public function login(): Response
    {
        $form = $this->formFactory->createNamed('', SecurityLoginType::class);

        return $this->render('shop/user/login.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
