<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Payment as BasePayment;

/**
 * @ORM\Table(name="sylius_payment")
 * @ORM\Entity
 */
class Payment extends BasePayment
{
    public const PAYMENT_CITELIS = 'CITELIS';
    public const PAYMENT_CITELIS_PAYMENT_N = 'CITELIS_PAYMENT_N';

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string|null
     */
    protected $transactionNumber;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string|null
     */
    protected $cardNumber;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     *
     * @var string|null
     */
    protected $transactionCertificat;

    /**
     * @ORM\Column(type="datetime", nullable=true)
     *
     * @var \DateTime|null
     */
    protected $transactionDate;

    /**
     * @ORM\Column(type="json", nullable=true)
     *
     * @var array
     */
    protected $transactionContent;

    /**
     * @return string|null
     */
    public function getCardNumber(): ?string
    {
        return $this->cardNumber;
    }

    /**
     * @param string|null $cardNumber
     *
     * @return Payment
     */
    public function setCardNumber(?string $cardNumber): self
    {
        $this->cardNumber = $cardNumber;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTransactionNumber(): ?string
    {
        return $this->transactionNumber;
    }

    /**
     * @param string|null $transactionNumber
     *
     * @return Payment
     */
    public function setTransactionNumber(?string $transactionNumber): self
    {
        $this->transactionNumber = $transactionNumber;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTransactionCertificat(): ?string
    {
        return $this->transactionCertificat;
    }

    /**
     * @param string|null $transactionCertificat
     *
     * @return Payment
     */
    public function setTransactionCertificat(?string $transactionCertificat): self
    {
        $this->transactionCertificat = $transactionCertificat;

        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getTransactionDate(): ?\DateTime
    {
        return $this->transactionDate;
    }

    /**
     * @param \DateTime|null $transactionDate
     *
     * @return Payment
     */
    public function setTransactionDate(?\DateTime $transactionDate): self
    {
        $this->transactionDate = $transactionDate;

        return $this;
    }

    /**
     * @return array
     */
    public function getTransactionContent(): array
    {
        return $this->transactionContent;
    }

    /**
     * @param array $transactionContent
     *
     * @return Payment
     */
    public function setTransactionContent(array $transactionContent): self
    {
        $this->transactionContent = $transactionContent;

        return $this;
    }
}
