<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\ResourceInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="app_setting")
 * @ORM\Entity(repositoryClass="App\Repository\SettingRepository")
 * @UniqueEntity("code")
 */
class Setting implements ResourceInterface
{
    const MINIMUM_ORDER = 'MINIMUM_ORDER';
    const HOLIDAY = 'HOLIDAY';
    const MINIMUM_SHIPPING_FEES = 'MINIMUM_SHIPPING_FEES';
    const MINIMUM_MANAGEMENT_FEES = 'MINIMUM_MANAGEMENT_FEES';
    const MANAGEMENT_FEES = 'MANAGEMENT_FEES';
    const MINIMUM_N_PAYMENTS = 'MINIMUM_N_PAYMENTS';

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     *
     * @var int
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Assert\NotBlank()
     *
     * @var string|null
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=255)
     * @Assert\NotBlank()
     *
     * @var string|null
     */
    private $code;

    /**
     * @ORM\Column(type="text")
     * @Assert\NotBlank()
     *
     * @var string|null
     */
    private $content;

    /**
     * @ORM\Column(type="boolean")
     *
     * @var bool
     */
    private $active;

    public function __construct()
    {
        $this->active = false;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Setting
     */
    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     *
     * @return Setting
     */
    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return Setting
     */
    public function setContent(string $content): self
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }

    /**
     * @param bool $active
     *
     * @return Setting
     */
    public function setActive(bool $active): self
    {
        $this->active = $active;

        return $this;
    }
}
