<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Resource\Model\ResourceInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="app_supplier")
 * @ORM\Entity(repositoryClass="App\Repository\SupplierRepository")
 * @UniqueEntity("code")
 */
class Supplier implements ResourceInterface
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     *
     * @var int
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $name;

    /**
     * @ORM\Column(type="string", length=50, unique=true)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $code;

    /**
     * @ORM\Column(type="string", length=255)
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $description;

    /**
     * @ORM\OneToMany(targetEntity="SupplierCoefficient", mappedBy="supplier", cascade={"persist"}, orphanRemoval=true)
     *
     * @var ArrayCollection
     */
    private $supplierCoefficients;

    public function __construct()
    {
        $this->supplierCoefficients = new ArrayCollection();
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return null|string
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Supplier
     */
    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return null|string
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string $code
     *
     * @return Supplier
     */
    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return null|string
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string $description
     *
     * @return Supplier
     */
    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return Collection
     */
    public function getSupplierCoefficients(): Collection
    {
        return $this->supplierCoefficients;
    }

    /**
     * @param SupplierCoefficient $supplierCoefficient
     *
     * @return Supplier
     */
    public function addSupplierCoefficient(SupplierCoefficient $supplierCoefficient): self
    {
        $supplierCoefficient->setSupplier($this);
        $this->supplierCoefficients->add($supplierCoefficient);

        return $this;
    }

    /**
     * @param SupplierCoefficient $supplierCoefficient
     *
     * @return Supplier
     */
    public function removeSupplierCoefficient(SupplierCoefficient $supplierCoefficient): self
    {
        $supplierCoefficient->setSupplier(null);
        $this->supplierCoefficients->removeElement($supplierCoefficient);

        return $this;
    }
}
