<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Taxonomy\Model\TaxonTranslation as BaseTaxonTranslation;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Table(name="sylius_taxon_translation")
 * @ORM\Entity
 */
class TaxonTranslation extends BaseTaxonTranslation
{
    /**
     * @ORM\Column(type="string", nullable=true)
     *
     * @Assert\NotBlank
     */
    protected $title;

    /**
     * @ORM\Column(type="text", nullable=true)
     *
     * @var string|null
     */
    private $content;

    public function getContent(): ?string
    {
        return $this->content;
    }

    /**
     * @return TaxonTranslation
     */
    public function setContent(?string $content): self
    {
        $this->content = $content;

        return $this;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): self
    {
        $this->title = $title;

        return $this;
    }
}
