<?php

declare(strict_types=1);

namespace App\Form\Extension;

use EWZ\Bundle\RecaptchaBundle\Form\Type\EWZRecaptchaType;
use Sylius\Bundle\CoreBundle\Form\Type\Customer\CustomerGuestType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CustomerGuestTypeExtension extends AbstractTypeExtension
{
    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'validation_groups' => function (FormInterface $form) {
                return ['app_b2c', 'app_b2g', 'app_b2b', 'sylius'];
            },
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('password', RepeatedType::class, [
            'type' => PasswordType::class,
            'label' => null,
            'invalid_message' => 'Les mots de passes doivent correspondre.',
            'first_options' => [
                'attr' => [
                    'placeholder' => 'Mot de passe',
                ],
            ],
            'second_options' => [
                'attr' => [
                    'placeholder' => 'Confirmez votre mot de passe',
                ],
            ],
        ])
            ->add('recaptcha', EWZRecaptchaType::class);
    }

    /**
     * {@inheritdoc}
     */
    public static function getExtendedTypes(): iterable
    {
        return [CustomerGuestType::class];
    }
}
