<?php

declare(strict_types=1);

namespace App\Form\Extension;

use App\Entity\Customer;
use Sylius\Bundle\CustomerBundle\Form\Type\CustomerType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

final class CustomerTypeExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('type', ChoiceType::class, [
                'choices' => [
                    Customer::TYPE_PARTICULIER => Customer::TYPE_PARTICULIER,
                    Customer::TYPE_SOCIETE => Customer::TYPE_SOCIETE,
                    Customer::TYPE_ADMINISTRATION => Customer::TYPE_ADMINISTRATION,
                ],
            ])
            ->add('civility', ChoiceType::class, [
                'choices' => [
                    Customer::CIVILITY_MR => Customer::CIVILITY_MR,
                    Customer::CIVILITY_MME => Customer::CIVILITY_MME,
                    'Autre' => Customer::CIVILITY_SOCIETE,
                    Customer::CIVILITY_EARL => Customer::CIVILITY_EARL,
                    Customer::CIVILITY_EURL => Customer::CIVILITY_EURL,
                    Customer::CIVILITY_GAEC => Customer::CIVILITY_GAEC,
                    Customer::CIVILITY_SARL => Customer::CIVILITY_SARL,
                    Customer::CIVILITY_SA => Customer::CIVILITY_SA,
                    Customer::CIVILITY_SAS => Customer::CIVILITY_SAS,
                    Customer::CIVILITY_SC => Customer::CIVILITY_SC,
                    Customer::CIVILITY_SCA => Customer::CIVILITY_SCA,
                    Customer::CIVILITY_SCI => Customer::CIVILITY_SCI,
                    Customer::CIVILITY_SCOP => Customer::CIVILITY_SCOP,
                    Customer::CIVILITY_SCP => Customer::CIVILITY_SCP,
                    Customer::CIVILITY_SICA => Customer::CIVILITY_SICA,
                    Customer::CIVILITY_SNC => Customer::CIVILITY_SNC,
                ],
            ])
            ->add('companyName', TextType::class, [
                'required' => false,
            ])
            ->add('faxNumber', TextType::class, [
                'required' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public static function getExtendedTypes(): iterable
    {
        return [CustomerType::class];
    }
}
