<?php

declare(strict_types=1);

namespace App\Form\Extension;

use App\Entity\Supplier;
use App\Form\Type\ProductCommercialDocumentationType;
use App\Form\Type\ProductTechnicalBurstType;
use App\Form\Type\ProductTechnicalDocumentationType;
use Sylius\Bundle\ProductBundle\Form\Type\ProductType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

final class ProductTypeExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('supplier', EntityType::class, [
                'class' => Supplier::class,
                'choice_label' => 'name',
            ])
            ->add('manufacturerReference', TextType::class, [
                'label' => 'app.ui.form.manufacturer_reference',
            ])
            ->add('thsReferenceSage', TextType::class, [
                'label' => 'app.ui.form.ths_reference_sage',
            ])
            ->add('thsReferenceUrl', TextType::class, [
                'label' => 'app.ui.form.ths_reference_url',
            ])
            ->add('minimumOrder', CheckboxType::class, [
                'label' => 'app.ui.form.minimum_order',
                'required' => false,
            ])
            ->add('freePort', CheckboxType::class, [
                'label' => 'app.ui.form.free_port',
                'required' => false,
            ])
            ->add('noIndex', CheckboxType::class, [
                'label' => 'app.ui.form.no_index',
                'required' => false,
            ])
            ->add('onSale', CheckboxType::class, [
                'label' => 'app.ui.form.on_sale',
                'required' => false,
            ])
            ->add('displayMenu', CheckboxType::class, [
                'label' => 'app.ui.form.display_menu',
                'required' => false,
            ])
            ->add('displayPrice', CheckboxType::class, [
                'label' => 'app.ui.form.display_price',
                'required' => false,
            ])
            ->add('displaySearch', CheckboxType::class, [
                'label' => 'app.ui.form.display_product_search',
                'required' => false,
            ])
            ->add('noLongerManufactured', CheckboxType::class, [
                'label' => 'app.ui.form.no_longer_manufactured',
                'required' => false,
            ])
            ->add('promotion', CheckboxType::class, [
                'label' => 'app.ui.form.promotion',
                'required' => false,
            ])
            ->add('saleSpareParts', CheckboxType::class, [
                'label' => 'app.ui.form.sale_spare_parts',
                'required' => false,
            ])
            ->add('technicalDocumentations', CollectionType::class, [
                'entry_type' => ProductTechnicalDocumentationType::class,
                'allow_add' => false,
                'allow_delete' => false,
                'by_reference' => false,
                'label' => 'app.ui.form.technical_documentation',
            ])
            ->add('commercialDocumentations', CollectionType::class, [
                'entry_type' => ProductCommercialDocumentationType::class,
                'allow_add' => false,
                'allow_delete' => false,
                'by_reference' => false,
                'label' => 'app.ui.form.commercial_documentation',
            ])
            ->add('technicalBursts', CollectionType::class, [
                'entry_type' => ProductTechnicalBurstType::class,
                'allow_add' => false,
                'allow_delete' => false,
                'by_reference' => false,
                'label' => 'app.ui.form.technical_burst',
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public static function getExtendedTypes(): iterable
    {
        return [ProductType::class];
    }
}
