<?php

declare(strict_types=1);

namespace App\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;

class AdminOrderQuotationType extends AbstractType
{
    /**
     * @param FormBuilderInterface $builder
     * @param array                $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('phone', TextType::class, [
                'required' => true,
                'label' => 'app.ui.form.phone',
            ])
            ->add('email', EmailType::class, [
                'required' => true,
                'label' => 'app.ui.form.email',
            ])
            ->add('total', TextType::class, [
                'required' => true,
                'label' => 'app.ui.form.total_vat_included',
            ])
            ->add('quotation', FileType::class, [
                'required' => true,
                'label' => 'app.ui.form.quotation',
            ])
        ;
    }
}
