<?php

declare(strict_types=1);

namespace App\Helper;

use App\Service\SettingService;
use Sylius\Component\Order\Model\OrderInterface;

class SettingHelper
{
    /** @var SettingService */
    private $settingService;

    /**
     * SettingHelper constructor.
     *
     * @param SettingService $settingService
     */
    public function __construct(SettingService $settingService)
    {
        $this->settingService = $settingService;
    }

    /**
     * @param OrderInterface $order
     *
     * @return bool
     */
    public function canUseNPayments(OrderInterface $order): bool
    {
        $minimum = $this->settingService->getMinimumNPayments();

        if (is_null($minimum)) {
            return false;
        }

        return $order->getTotal() > $minimum;
    }
}
