<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190125091604 extends AbstractMigration
{
    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf('mysql' !== $this->connection->getDatabasePlatform()->getName(), 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE sylius_taxon ADD page_id INT DEFAULT NULL, ADD menu TINYINT(1) DEFAULT \'0\' NOT NULL');
        $this->addSql('ALTER TABLE sylius_taxon ADD CONSTRAINT FK_CFD811CAC4663E4 FOREIGN KEY (page_id) REFERENCES bitbag_cms_page (id)');
        $this->addSql('CREATE INDEX IDX_CFD811CAC4663E4 ON sylius_taxon (page_id)');
        $this->addSql('ALTER TABLE sylius_order ADD order_token VARCHAR(255) DEFAULT NULL, ADD quotation_token VARCHAR(255) DEFAULT NULL, ADD quotation_pdf VARCHAR(255) DEFAULT NULL, DROP commande_token, DROP devis_token, DROP devis_pdf, CHANGE id_user_suiveur id_user_tracking INT DEFAULT NULL, CHANGE mail_commande mail_order TINYINT(1) DEFAULT NULL');
        $this->addSql('ALTER TABLE sylius_product ADD manufacturerReference VARCHAR(255) DEFAULT NULL, ADD thsReferenceSage VARCHAR(255) DEFAULT NULL, ADD thsReferenceUrl VARCHAR(255) DEFAULT NULL, ADD minimumOrder TINYINT(1) NOT NULL, ADD freePort TINYINT(1) NOT NULL, ADD noIndex TINYINT(1) NOT NULL');
        $this->addSql('ALTER TABLE sylius_payment ADD transactionContent LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\'');
        $this->addSql('ALTER TABLE bitbag_cms_page_channels DROP FOREIGN KEY FK_DCA4269C4663E4');
        $this->addSql('ALTER TABLE bitbag_cms_page_channels ADD CONSTRAINT FK_DCA4269C4663E4 FOREIGN KEY (page_id) REFERENCES bitbag_cms_page (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE webgriffe_sylius_shipping_table_rate CHANGE weightLimitToRate weightLimitToRate LONGTEXT NOT NULL COMMENT \'(DC2Type:json_array)\'');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf('mysql' !== $this->connection->getDatabasePlatform()->getName(), 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE bitbag_cms_page_channels DROP FOREIGN KEY FK_DCA4269C4663E4');
        $this->addSql('ALTER TABLE bitbag_cms_page_channels ADD CONSTRAINT FK_DCA4269C4663E4 FOREIGN KEY (page_id) REFERENCES bitbag_cms_page (id)');
        $this->addSql('ALTER TABLE sylius_order ADD commande_token VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, ADD devis_token VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, ADD devis_pdf VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, DROP order_token, DROP quotation_token, DROP quotation_pdf, CHANGE id_user_tracking id_user_suiveur INT DEFAULT NULL, CHANGE mail_order mail_commande TINYINT(1) DEFAULT NULL');
        $this->addSql('ALTER TABLE sylius_payment DROP transactionContent');
        $this->addSql('ALTER TABLE sylius_product DROP manufacturerReference, DROP thsReferenceSage, DROP thsReferenceUrl, DROP minimumOrder, DROP freePort, DROP noIndex');
        $this->addSql('ALTER TABLE sylius_taxon DROP FOREIGN KEY FK_CFD811CAC4663E4');
        $this->addSql('DROP INDEX IDX_CFD811CAC4663E4 ON sylius_taxon');
        $this->addSql('ALTER TABLE sylius_taxon DROP page_id, DROP menu');
        $this->addSql('ALTER TABLE webgriffe_sylius_shipping_table_rate CHANGE weightLimitToRate weightLimitToRate LONGTEXT NOT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:json)\'');
    }
}
