<?php

declare(strict_types=1);

namespace App\Model;

use Symfony\Component\Validator\Constraints as Assert;

class AdminOrderCart implements AdminOrderInterface
{
    /**
     * @var string|null
     */
    protected $companyName;

    /**
     * @var string|null
     */
    protected $lastName;

    /**
     * @var string|null
     */
    protected $firstName;

    /**
     * @var string
     *
     * @Assert\Email()
     * @Assert\NotBlank()
     */
    protected $email;

    /**
     * @var string
     *
     * @Assert\NotBlank()
     */
    protected $phone;

    /**
     * @var string|null
     */
    protected $total;

    /**
     * @var array
     */
    protected $items;

    public function __construct()
    {
        $this->items = [];
    }

    /**
     * @return string|null
     */
    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    /**
     * @param string|null $companyName
     *
     * @return AdminOrderTicket
     */
    public function setCompanyName(?string $companyName): AdminOrderInterface
    {
        $this->companyName = $companyName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     *
     * @return AdminOrderTicket
     */
    public function setLastName(?string $lastName): AdminOrderInterface
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     *
     * @return AdminOrderTicket
     */
    public function setFirstName(?string $firstName): AdminOrderInterface
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return AdminOrderInterface
     */
    public function setEmail(string $email): AdminOrderInterface
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     *
     * @return AdminOrderInterface
     */
    public function setPhone(string $phone): AdminOrderInterface
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTotal(): ?string
    {
        return $this->total;
    }

    /**
     * @param string $total
     *
     * @return AdminOrderInterface
     */
    public function setTotal(string $total): AdminOrderInterface
    {
        $this->total = $total;

        return $this;
    }

    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @param array $items
     *
     * @return AdminOrderCart
     */
    public function setItems(array $items): self
    {
        $this->items = $items;

        return $this;
    }

    /**
     * @param $item
     *
     * @return AdminOrderCart
     */
    public function addItem($item): self
    {
        $this->items[] = $item;

        return $this;
    }
}
