<?php

declare(strict_types=1);

namespace App\Model;

use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;

class AdminOrderQuotation implements AdminOrderInterface
{
    /**
     * @var string|null
     */
    protected $companyName;

    /**
     * @var string|null
     */
    protected $lastName;

    /**
     * @var string|null
     */
    protected $firstName;

    /**
     * @var UploadedFile
     *
     * @Assert\NotBlank()
     */
    protected $quotation;

    /**
     * @var string|null
     *
     * @Assert\Email()
     * @Assert\NotBlank()
     */
    protected $email;

    /**
     * @var string|null
     *
     * @Assert\NotBlank()
     */
    protected $phone;

    /**
     * @var string|null
     *
     * @Assert\NotBlank()
     */
    protected $total;

    /**
     * @return string|null
     */
    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    /**
     * @param string|null $companyName
     *
     * @return AdminOrderTicket
     */
    public function setCompanyName(?string $companyName): AdminOrderInterface
    {
        $this->companyName = $companyName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @param string|null $lastName
     *
     * @return AdminOrderTicket
     */
    public function setLastName(?string $lastName): AdminOrderInterface
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @param string|null $firstName
     *
     * @return AdminOrderTicket
     */
    public function setFirstName(?string $firstName): AdminOrderInterface
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return UploadedFile|null
     */
    public function getQuotation(): ?UploadedFile
    {
        return $this->quotation;
    }

    /**
     * @param UploadedFile $quotation
     *
     * @return AdminOrderQuotation
     */
    public function setQuotation(UploadedFile $quotation): self
    {
        $this->quotation = $quotation;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return AdminOrderInterface
     */
    public function setEmail(string $email): AdminOrderInterface
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     *
     * @return AdminOrderInterface
     */
    public function setPhone(string $phone): AdminOrderInterface
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * @return string|null
     */
    public function getTotal(): ?string
    {
        return $this->total;
    }

    /**
     * @param string $total
     *
     * @return AdminOrderInterface
     */
    public function setTotal(string $total): AdminOrderInterface
    {
        $this->total = $total;

        return $this;
    }
}
