<?php

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Address;
use App\Entity\Order;
use Doctrine\ORM\NonUniqueResultException;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\AddressRepository as BaseAddressRepository;
use Sylius\Component\Core\Model\CustomerInterface;

class AddressRepository extends BaseAddressRepository
{
    /**
     * @param CustomerInterface $customer
     *
     * @return Address|null
     *
     * @throws NonUniqueResultException
     */
    public function findLastOneUsedByCustomer(CustomerInterface $customer): ?Address
    {
        return $this->createQueryBuilder('a')
            ->innerJoin('a.customer', 'c')
            ->innerJoin('c.orders', 'o')
            ->andWhere('c = :customer')
            ->andWhere('o.state IN (:states)')
            ->addOrderBy('a.id', 'DESC')
            ->setMaxResults(1)
            ->setParameters([
                'customer' => $customer,
                'states' => [Order::STATE_NEW, Order::STATE_FULFILLED],
            ])
            ->getQuery()
            ->getOneOrNullResult();
    }
}
