<?php

declare(strict_types=1);

namespace App\Repository;

use Sylius\AdminOrderCreationPlugin\Doctrine\ORM\ProductVariantRepositoryInterface;
use Sylius\Bundle\CoreBundle\Doctrine\ORM\ProductVariantRepository as BaseProductVariantRepository;

final class ProductVariantRepository extends BaseProductVariantRepository implements ProductVariantRepositoryInterface
{
    public function findByPhraseAndChannelCode(string $phrase, string $channelCode, string $locale): array
    {
        return $this->createQueryBuilder('o')
            ->leftJoin('o.translations', 'translation', 'WITH', 'translation.locale = :locale')
            ->innerJoin('o.product', 'p')
            ->innerJoin('p.channels', 'c')
            ->andWhere('p.onSale = true')
            ->andWhere('p.enabled = true')
            ->andWhere('c.code = :channel')
            ->andWhere('p.code LIKE :phrase OR p.thsReferenceSage LIKE :phrase OR p.manufacturerReference LIKE :phrase')
            ->andWhere('c.code = :channel')
            ->addOrderBy('o.code')
            ->setMaxResults(10)
            ->setParameter('channel', $channelCode)
            ->setParameter('phrase', $phrase.'%')
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getResult()
        ;
    }
}
