<?php

declare(strict_types=1);

namespace App\Repository;

use App\Entity\Product;
use Sylius\Bundle\TaxonomyBundle\Doctrine\ORM\TaxonRepository as baseTaxonRepository;
use Sylius\Component\Core\Model\Taxon;

class TaxonRepository extends baseTaxonRepository
{
    public function findByParent(Taxon $taxon): array
    {
        return $this->createQueryBuilder('t')
            ->innerJoin('t.parent', 'p')
            ->andWhere('p = :parent')
            ->setParameter('parent', $taxon)
            ->getQuery()
            ->getResult();
    }

    /**
     * {@inheritdoc}
     */
    public function findRootNodesMenu(): array
    {
        return $this->createQueryBuilder('o')
            ->innerJoin('o.children', 'c')
            ->andWhere('o.parent IS NULL')
            ->andWhere('o.menu = 1')
            ->addOrderBy('o.position')
            ->getQuery()
            ->getResult()
            ;
    }

    /**
     * Return searchable taxon which have enabled and searchable product.
     */
    public function findAllSearchableWithSearchableProduct(string $locale): array
    {
        return $this->createQueryBuilder('t')
            ->innerJoin('t.translations', 'tr', 'WITH', 'tr.locale = :locale')
            ->andWhere('t.displaySearch = true')
            ->innerJoin(Product::class, 'p')
                ->andWhere('p.enabled = true')
                ->andWhere('p.displaySearch = true')
            ->innerJoin('p.mainTaxon', 'mt', 'WITH', 'mt.id = t.id')
            ->addOrderBy('tr.name')
            ->setParameter('locale', $locale)
            ->getQuery()
            ->getResult();
    }
}
