<?php

declare(strict_types=1);

namespace App\Service;

use App\Entity\Customer;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Core\Model\ShopUserInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;
use Sylius\Component\Resource\Repository\RepositoryInterface;

class OrderCheckoutManager
{
    /** @var FactoryInterface */
    private $factoryShopUser;

    /** @var RepositoryInterface */
    private $repositoryShopUser;

    /**
     * OrderCheckoutManager constructor.
     *
     * @param FactoryInterface    $factoryShopUser
     * @param RepositoryInterface $repositoryShopUser
     */
    public function __construct(
        FactoryInterface $factoryShopUser,
        RepositoryInterface $repositoryShopUser
    ) {
        $this->factoryShopUser = $factoryShopUser;
        $this->repositoryShopUser = $repositoryShopUser;
    }

    /**
     * @param OrderInterface $order
     */
    public function process(OrderInterface $order): void
    {
        /** @var Customer $customer */
        $customer = $order->getCustomer();

        if (is_null($customer->getUser())) {
            /** @var ShopUserInterface $user */
            $user = $this->factoryShopUser->createNew();
            $user->setUsername($customer->getEmail());
            $user->setUsernameCanonical($customer->getEmailCanonical());
            $user->setCustomer($customer);
            $user->setPlainPassword($customer->getPassword());
            $user->setEnabled(true);

            $this->repositoryShopUser->add($user);
        }
    }
}
