<?php

declare(strict_types=1);

namespace App\Service;

use App\Entity\Order;
use App\Entity\SendingCriterion;
use Psr\Log\LoggerInterface;
use Sylius\Component\Core\Model\OrderItem;
use Sylius\Component\Resource\Repository\RepositoryInterface;

class SendingCriterionService
{
    /** @var LoggerInterface */
    private $logger;

    /** @var RepositoryInterface */
    private $repositoryOrder;

    /** @var RepositoryInterface */
    private $repositoryProduct;

    /** @var RepositoryInterface */
    private $repositorySendingCriterion;

    /** @var OrderService */
    private $orderService;

    /**
     * SendingCriterionService constructor.
     *
     * @param LoggerInterface     $logger
     * @param RepositoryInterface $repositoryOrder
     * @param RepositoryInterface $repositoryProduct
     * @param RepositoryInterface $repositorySendingCriterion
     * @param OrderService        $orderService
     */
    public function __construct(
        LoggerInterface $logger,
        RepositoryInterface $repositoryOrder,
        RepositoryInterface $repositoryProduct,
        RepositoryInterface $repositorySendingCriterion,
        OrderService $orderService
    ) {
        $this->logger = $logger;
        $this->repositoryOrder = $repositoryOrder;
        $this->repositoryProduct = $repositoryProduct;
        $this->repositorySendingCriterion = $repositorySendingCriterion;
        $this->orderService = $orderService;
    }

    /**
     * @param Order $order
     *
     * @return Order
     */
    public function handleOrder(Order $order): Order
    {
        $rules = $this->repositorySendingCriterion->findAll();
        $type = $order->getShippingAddress()->getType();
        $nbOrders = $this->repositoryOrder->countByCustomer($order->getCustomer());
        $quantities = 0;

        /** @var OrderItem $item */
        foreach ($order->getItems() as $item) {
            $quantities += $item->getQuantity();
        }

        $orderTotal = $order->getTotal() / 100;

        /** @var SendingCriterion $rule */
        foreach ($rules as $rule) {
            try {
                if ($type == $rule->getType() || '' == $rule->getType()) {
                    $code = $rule->getProductCode();
                    $product = $this->repositoryProduct->findOneBy(['code' => $code]);

                    if (!$product) {
                        throw new \Exception("Product $code does not exist.");
                    }

                    $alreadyOrderProduct = $this->repositoryOrder->alreadyOrderProduct($product, $order->getCustomer());

                    if ($alreadyOrderProduct) {
                        continue;
                    }

                    $rncs = $rule->getOrderNumberSign();
                    $rnc = $rule->getOrderNumber();
                    $rnas = $rule->getNumberOfProductSign();
                    $rna = $rule->getNumberOfProduct();
                    $rtcs = $rule->getOrderTotalSign();
                    $rtc = $rule->getOrderTotal();

                    $isOK = eval("return ($nbOrders $rncs $rnc && $quantities $rnas $rna && $orderTotal $rtcs $rtc);");

                    if ($isOK) {
                        $this->orderService->addProductToOrder($order, $product, 1, 0);
                        $this->orderService->processOrder($order);
                    }
                }
            } catch (\Exception $e) {
                $this->logger->error($e->getMessage());
            }
        }

        return $order;
    }
}
