<?php

/*
 * This file has been created by developers from BitBag.
 * Feel free to contact us once you face any issues or want to start
 * another great project.
 * You can find more information about us on https://bitbag.shop and write us
 * an email on mikolaj.krol@bitbag.pl.
 */

declare(strict_types=1);

namespace spec\BitBag\SyliusCmsPlugin\Entity;

use BitBag\SyliusCmsPlugin\Entity\MediaTranslation;
use BitBag\SyliusCmsPlugin\Entity\MediaTranslationInterface;
use BitBag\SyliusCmsPlugin\Entity\PageImageInterface;
use PhpSpec\ObjectBehavior;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TranslationInterface;

final class MediaTranslationSpec extends ObjectBehavior
{
    function it_is_initializable(): void
    {
        $this->shouldHaveType(MediaTranslation::class);
    }

    function it_is_a_resource(): void
    {
        $this->shouldHaveType(ResourceInterface::class);
    }

    function it_implements_media_translation_interface(): void
    {
        $this->shouldHaveType(MediaTranslationInterface::class);
        $this->shouldHaveType(TranslationInterface::class);
    }

    function it_allows_access_via_properties(): void
    {
        $this->setName('Video');
        $this->getName()->shouldReturn('Video');

        $this->setContent('Lorem ipsum');
        $this->getContent()->shouldReturn('Lorem ipsum');

        $this->setAlt('video');
        $this->getAlt()->shouldReturn('video');

        $this->setLink('https://github.com/Netimage/SyliusCmsPlugin');
        $this->getLink()->shouldReturn('https://github.com/Netimage/SyliusCmsPlugin');
    }
}
