<?php

declare(strict_types=1);

namespace HmongLBM\SyliusCitelisPlugin\Action;

use HmongLBM\SyliusCitelisPlugin\Bridge\CitelisBridgeInterface;
use HmongLBM\SyliusCitelisPlugin\SetCitelis;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\Exception\UnsupportedApiException;
use Payum\Core\Payum;
use Payum\Core\Reply\HttpPostRedirect;
use Payum\Core\Reply\HttpRedirect;

final class CitelisAction implements ApiAwareInterface, ActionInterface
{
    private $api = [];

    /**
     * @var Payum
     */
    private $payum;

    /**
     * {@inheritDoc}
     */
    public function setApi($api)
    {
        if (!is_array($api)) {
            throw new UnsupportedApiException('Not supported.');
        }

        $this->api = $api;
    }

    /**
     * @param Payum $payum
     */
    public function __construct(Payum $payum)
    {
        $this->payum = $payum;
    }

    /**
     * {@inheritDoc}
     */
    public function execute($request)
    {
        RequestNotSupportedException::assertSupports($this, $request);

        $model = ArrayObject::ensureArrayObject($request->getModel());

        $parm = "merchant_id=".$this->api['merchant_id'];
        $parm = "$parm capture_mode=".$this->api['capture_mode'];
        $parm = "$parm capture_day=".$this->api['capture_day'];

        if (CitelisBridgeInterface::CAPTURE_MODE_PAYMENT_N === $this->api['capture_mode']) {
            $initialAmount = round($model->get('totalAmount') / $this->api['nb_payment']);
            $parm = "$parm data=NB_PAYMENT=".$this->api['nb_payment']."\;PERIOD=".$this->api['period']."\;INITIAL_AMOUNT=$initialAmount";
        }

        $parm = "$parm merchant_country=".$this->api['merchant_country'];
        $parm = "$parm amount=".$model->get('totalAmount');
        $parm = "$parm currency_code=".$this->api['currency_code'];
        $parm = "$parm pathfile=".$this->api['cgi_bin_dir']."/citelis/param/pathfile";
        $parm = "$parm transaction_id=".date("His");
        $parm = "$parm order_id=".$model->get('order')->getId();
        $parm = "$parm normal_return_url=".$request->getToken()->getAfterUrl();
        $parm = "$parm cancel_return_url=".$request->getToken()->getAfterUrl();

        $notify = $this->payum->getTokenFactory()->createNotifyToken(
            $request->getToken()->getGatewayName(),
            $request->getToken()->getDetails()
        );

        $parm = "$parm automatic_response_url=".$notify->getTargetUrl();
        $path_bin = $this->api['cgi_bin_dir']."/citelis/bin/request";
        $result = exec("$path_bin $parm");
        $tableau = explode ("!", "$result");
        $doc = new \DOMDocument();
        $doc->loadHTML($tableau[3]);
        $xpath = new \DOMXPath($doc);
        $nodes = $xpath->query('//form');
        $node = $nodes->item(0);
        $action = $node->getAttribute('action');
        $nodes = $xpath->query('//input[@name="DATA"]');
        $node = $nodes->item(0);
        $data = $node->getAttribute('value');

        throw new HttpPostRedirect($action, [
            'DATA' => $data,
            'CB.x' => 15,
            'CB.y' => 15
        ]);
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return $request instanceof SetCitelis
            && $request->getModel() instanceof \ArrayObject;
    }
}
