<?php

declare(strict_types=1);

namespace HmongLBM\SyliusCitelisPlugin\Action;

use DateTime;
use HmongLBM\SyliusCitelisPlugin\Bridge\CitelisBridgeInterface;
use Payum\Core\Action\ActionInterface;
use Payum\Core\ApiAwareInterface;
use Payum\Core\Bridge\Spl\ArrayObject;
use Payum\Core\Exception\RequestNotSupportedException;
use Payum\Core\Exception\UnsupportedApiException;
use Payum\Core\Request\GetStatusInterface;
use Sylius\Component\Core\Model\Payment;

final class StatusAction implements ApiAwareInterface, ActionInterface
{
    /**
     * @var array
     */
    private $api = [];

    /**
     * {@inheritDoc}
     */
    public function setApi($api)
    {
        if (!is_array($api)) {
            throw new UnsupportedApiException('Not supported.');
        }

        $this->api = $api;
    }

    /**
     * {@inheritDoc}
     */
    public function execute($request)
    {
        if (!isset($_POST['DATA'])) {
            $request->markNew();

            return;
        }

        /** @var $request GetStatusInterface */
        RequestNotSupportedException::assertSupports($this, $request);

        $model = ArrayObject::ensureArrayObject($request->getModel());

        $message = "message=".$_POST['DATA'];
        $pathfile = "pathfile=".$this->api['cgi_bin_dir']."/citelis/param/pathfile";
        $path_bin = $this->api['cgi_bin_dir']."/citelis/bin/response";
        $result = exec("$path_bin $pathfile $message");
        $tableau = explode("!", $result);

        $code = $tableau[1];
        $error = $tableau[2];
        $merchant_id = $tableau[3];
        $merchant_country = $tableau[4];
        $amount = $tableau[5];
        $transaction_id = $tableau[6];
        $payment_means = $tableau[7];
        $transmission_date = $tableau[8];
        $payment_time = $tableau[9];
        $payment_date = $tableau[10];
        $response_code = $tableau[11];
        $payment_certificate = $tableau[12];
        $authorisation_id = $tableau[13];
        $currency_code = $tableau[14];
        $card_number = $tableau[15];
        $cvv_flag = $tableau[16];
        $cvv_response_code = $tableau[17];
        $bank_response_code = $tableau[18];
        $complementary_code = $tableau[19];
        $complementary_info = $tableau[20];
        $return_context = $tableau[21];
        $caddie = $tableau[22];
        $receipt_complement = $tableau[23];
        $merchant_language = $tableau[24];
        $language = $tableau[25];
        $customer_id = $tableau[26];
        $order_id = $tableau[27];
        $customer_email = $tableau[28];
        $customer_ip_address = $tableau[29];
        $capture_day = $tableau[30];
        $capture_mode = $tableau[31];
        $data = $tableau[32];

        /**
         * 32 => "NB_PAYMENT=3;PERIOD=30;INITIAL_AMOUNT=3000;PAYMENT_DUE_DATES=20190828/3000,20190927/3197,20191027/3197"
         */
        /*if ('PAYMENT_N' === $capture_mode) {
            $data = explode(';', $data);
            $details = [];

            foreach ($data as $_data) {
                $info = explode('=', $_data);
                $details[$info[0]] = $info[1];
            }

            $originalPayment = $request->getFirstModel();
            $className = get_class($originalPayment);

            $currencyCode = $originalPayment->getCurrencyCode();
            $method = $originalPayment->getMethod();
            $state = $originalPayment->getState();

            $order = $originalPayment->getOrder();
            $order->removePayments();
            $paymentDueDates = explode(',', $details['PAYMENT_DUE_DATES']);
            $result = [];

            foreach ($paymentDueDates as $paymentDueDate) {
                $result[] = explode('/', $paymentDueDate);
            }

            $details['PAYMENT_DUE_DATES'] = $result;

            for ($i = 0; $i < $details['NB_PAYMENT']; $i++) {
                $payment = new $className();
                $payment->setAmount((int) $details['PAYMENT_DUE_DATES'][$i][1]);
                $payment->setCurrencyCode($currencyCode);
                $payment->setMethod($method);
                $payment->setOrder($order);
                $payment->setState($state);
                $payment->setCreatedAt(new DateTime());
                $payment->setUpdatedAt(new DateTime());
                $payment->setCardNumber($card_number);
                $payment->setTransactionNumber($transaction_id);
                $payment->setTransactionCertificat($payment_certificate);
                $order->addPayment($payment);

                $dateTime = DateTime::createFromFormat('YmdHis', $payment_date.$payment_time);

                if ($dateTime) {
                    $payment->setTransactionDate($dateTime);
                }

                $payment->setTransactionContent($tableau);
            }
        } else {*/
            $payment = $request->getFirstModel();
            $payment->setCardNumber($card_number);
            $payment->setTransactionNumber($transaction_id);
            $payment->setTransactionCertificat($payment_certificate);
            $dateTime = DateTime::createFromFormat('YmdHis', $payment_date.$payment_time);

            if ($dateTime) {
                $payment->setTransactionDate($dateTime);
            }

            $payment->setTransactionContent($tableau);
        //}

        if (in_array($response_code, [
            CitelisBridgeInterface::RESPONSE_CODE_0,
            CitelisBridgeInterface::RESPONSE_CODE_00,
        ])) {
            $request->markCaptured();

            return;
        }

        if (CitelisBridgeInterface::RESPONSE_CODE_02 === $response_code) {
            $request->markSuspended();

            return;
        }

        $request->markCanceled();
    }

    /**
     * {@inheritDoc}
     */
    public function supports($request)
    {
        return $request instanceof GetStatusInterface &&
            $request->getModel() instanceof \ArrayAccess
        ;
    }
}
