<h2 align="center">Supporting Payum</h2>

Payum is an MIT-licensed open source project with its ongoing development made possible entirely by the support of community and our customers. If you'd like to join them, please consider:

- [Become a sponsor](https://www.patreon.com/makasim)
- [Become our client](http://forma-pro.com/)

---

# Payum docs

* ### General
    * [Get it started](get-it-started.md)
    * [Architecture](the-architecture.md)
    * [Storages](storages.md)
    * [Configure gateway in backend](configure-gateway-in-backend.md)
    * [Encrypt gateway configs stored in database](encrypt-gateway-configs-stored-in-database.md)
    * [Working with sensitive information](working-with-sensitive-information.md)
    * [Mask credit card number](mask-credit-card-number.md)
    * [Instant payment notification](instant-payment-notification.md)
    * [Develop gateway with payum](develop-gateway-with-payum.md)
    * [Supported gateways](supported-gateways.md)
    * [Frameworks and e-commerce integration](frameworks-and-e-commerce-integration.md)
    * [Logger](logger.md)
    * [Debugging](debugging.md)
    * [ISO4217. Currency details](iso4217-or-currency-details.md)
    * [Payum vs Omnipay](payum-vs-omnipay.md)
    * [PHP7](php7.md)
    * [Symfony. The event dispatcher extension](event-dispatcher.md)
    * [How to contribute from sub repository](how-to-contribute-from-subrepository.md)

* ### Authorize.Net AIM
    * [Get it started](authorize-net/aim/get-it-started.md)
    
* ### Be2Bill
    * [Direct](be2bill/direct.md)
    * [Offsite](be2bill/offsite.md)

* ### Klarna Checkout
    * [Get it started](klarna/checkout/get-it-started.md)
    
* ### Klarna Invoice
    * [Get it started](klarna/invoice/get-it-started.md)
    
* ### Offline 
    * [Get it started](offline/get-it-started.md)

* ### Payex
    * [Get it started](payex/get-it-started.md)
    
* ### Paypal Express Checkout
    * [Get it started](paypal/express-checkout/get-it-started.md)
    * [Authorize order](paypal/express-checkout/authorize-order.md)
    * [Confirm order step](paypal/express-checkout/confirm-order-step.md)
    * [Recurring payments basics](paypal/express-checkout/recurring-payments-basics.md)
    * [Cancel recurring payment](paypal/express-checkout/cancel-recurring-payment.md)
    * [Authorize token custom query parameters](paypal/express-checkout/authorize-token-custom-query-parameters.md)

* ### Paypal Pro Checkout
    * [Get it started](paypal/pro-checkout/get-it-started.md)

* ### Paypal Pro Hosted 
    * [Get it started](paypal/pro-hosted/get-it-started.md)

* ### Paypal Masspay
    * [Get it started](paypal/masspay/get-it-started.md)
    
* ### Paypal Rest
    * [Get it started](paypal/rest/get-it-started.md)
    * [Credit card purchase](paypal/rest/credit-card-purchase.md)

* ### Paypal IPN
    * [Get it started](paypal/ipn/get-it-started.md)

* ### Sofort  
    * [Get it started](sofort/get-it-started.md)
    * [Disable notifications](sofort/disable-notifications.md)
    
* ### Stripe
    * [Stripe.js](stripe/js.md)
    * [Checkout](stripe/checkout.md)
    * [Direct](stripe/direct.md)
    * [Raw capture](stripe/raw-capture.md)
    * [Store Card and use later](stripe/store-card-and-use-later.md)
    * [Subscription billing](stripe/subscription-billing.md)
    
* ### Symfony. Payum Bundle
    * [Get it started. Capture](symfony/get-it-started.md)
    * [Authorize](symfony/authorize.md)
    * [Refund](symfony/refund.md)
    * [Storages](symfony/storages.md)
    * [Done action](symfony/purchase-done-action.md)
    * [Configure payment in backend](symfony/configure-payment-in-backend.md)
    * [Encrypt gateway configs stored in database](symfony/encrypt-gateway-configs-stored-in-database.md)
    * [Custom action usage](symfony/custom-action-usage.md)
    * [Custom api usage](symfony/custom-api-usage.md)
    * [Custom purchase examples](symfony/custom-purchase-examples.md)
    * [Sandbox](symfony/sandbox.md)
    * [Console commands](symfony/console-commands.md)
    * [Debugging](symfony/debugging.md)
    * [Configuration reference](symfony/configuration-reference.md)
    * [Container tags](symfony/container-tags.md)
    * [ISO4217. Currency details](symfony/iso4217-or-currency-details.md)

* ### Laravel. Payum Package
    * [Get it started](laravel/get-it-started.md)
    * [Examples](laravel/examples.md)
    * [Eloquent storage](laravel/eloquent-storage.md)
    * [Payment done controller](laravel/payment-done-controller.md)
    * [Store gateway config in database](laravel/store-gateway-config-in-database.md)
    * [Blade templates](laravel/blade-templating.md)
    
* ### Silex. Payum Provider
    * [Get it started](silex/get-it-started.md)
    * [Payment done controller](silex/payment-done-controller.md)
    
* ### Symfony. JMS Payment Bridge
    * [Get it started. Capture](jms-payment-bridge/get-it-started.md)

* ### [Zend. Payum Module (External)](https://github.com/Payum/PayumModule)

* ### [Yii. Payum Extension (External)](https://github.com/Payum/PayumYiiExtension)

* ### [Omnipay Bridge (External)](https://github.com/Payum/OmnipayBridge)

* ### [Payum Server (External)](https://github.com/Payum/PayumServer)
