<?php

declare(strict_types=1);

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\IntlBundle;

use Sonata\IntlBundle\DependencyInjection\Compiler\StrictPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class SonataIntlBundle extends Bundle
{
    /**
     * Returns a cleaned version number.
     *
     * @static
     *
     * @param $version
     *
     * @return string
     */
    public static function getSymfonyVersion($version)
    {
        return implode('.', \array_slice(array_map(static function ($val) {
            return (int) $val;
        }, explode('.', $version)), 0, 3));
    }

    /**
     * {@inheritdoc}
     */
    public function build(ContainerBuilder $container)
    {
        $container->addCompilerPass(new StrictPass());
    }
}
